<?php
include "./autoload.php";
include "./admin/configuracoes/functions.php";

// Configuração do CORS para permitir todas as origens
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");



// Verifica se a requisição é do tipo POST
if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    // Instancia a classe Aplicativos
    $loja = new Loja;
    
    // Atualiza a contagem de downloads do aplicativo
    $result = $loja->color();
    
    echo json_encode($result);

} else {
    // Retorna uma resposta de erro se o método HTTP não for POST
    http_response_code(405);
    echo json_encode([
        "status" => "error",
        "message" => "Método não permitido. Use GET."
    ]);
}