<?php
include "./autoload.php";
include "./admin/configuracoes/functions.php";

// Configuração do CORS para permitir todas as origens
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Verifica se a requisição é do tipo POST
if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    // Obtém os dados enviados no corpo da requisição
    $data = json_decode(file_get_contents("php://input"), true);

    // Verifica se os dados necessários foram enviados
    if (isset($data['id'])) {
        $id = $data['id'];

        // Instancia a classe Aplicativos
        $aplicativos = new Aplicativos;

        // Atualiza a contagem de downloads do aplicativo
        $result = $aplicativos->updateDownloadCount($id);

        if ($result) {
            // Retorna uma resposta de sucesso
            echo json_encode([
                "status" => "success",
                "message" => "Contagem de downloads atualizada com sucesso."
            ]);
        } else {
            // Retorna uma resposta de erro se a atualização falhar
            http_response_code(500);
            echo json_encode([
                "status" => "error",
                "message" => "Falha ao atualizar a contagem de downloads."
            ]);
        }
    } else {
        // Retorna uma resposta de erro se os dados necessários não forem enviados
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Dados insuficientes fornecidos."
        ]);
    }
} else {
    // Retorna uma resposta de erro se o método HTTP não for POST
    http_response_code(405);
    echo json_encode([
        "status" => "error",
        "message" => "Método não permitido. Use POST."
    ]);
}
