$(document).on("click", ".alterarSenha", function(e) {
    e.preventDefault();

    var user_id = $(this).data("id"); // Assume que o ID do usuário está armazenado no atributo data-id do botão
    
    const form = `
        <div class="basic-form">
            <div class="form-row">
                <div class="form-group col-md-12 input-primary">
                    <label><strong>Senha antiga*</strong></label>
                    <input type="text" class="form-control" id="senhaAntiga" required>
                </div>
                <div class="form-group col-md-6 input-primary">
                    <label><strong>Nova senha*</strong></label>
                    <input type="text" class="form-control" id="novaSenha" required>
                </div>
                <div class="form-group col-md-6 input-primary">
                    <label><strong>Repita a senha*</strong></label>
                    <input type="text" class="form-control" id="novaSenhaConfirmacao" required>
                </div>
            </div>
        </div>
    `;

    bootbox.dialog({
        title: "Confirmação de alteração de senha",
        message: form,
        buttons: {
            confirm: {
                label: "<div class='d-flex align-items-center'><i class='bx bx-check mr-2'></i> Confirmar</div>",
                className: 'btn btn-sm btn-primary',
                callback: function() {
                    // Mostrar o overlay
                    $.blockUI({ 
                        message: '<h1>Processando...</h1>', 
                        css: { 
                            border: 'none', 
                            padding: '15px', 
                            backgroundColor: '#fff', 
                            'border-radius': '10px', 
                            opacity: .8, 
                            color: '#000' 
                        } 
                    });
                    
                    // Cria um FormData object
                    let formData = new FormData();
                    formData.append('id', user_id);
                    formData.append('senhaAntiga', $("#senhaAntiga").val());
                    formData.append('novaSenha', $("#novaSenha").val());
                    formData.append('novaSenhaConfirmacao', $("#novaSenhaConfirmacao").val());
                    
                    $.ajax({
                        url: "./api/usuarios/alterarSenha", // URL para o endpoint de alteração de senha
                        type: "POST",
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(res) {
                            $.unblockUI(); // Remove o overlay
                            if (res.status) {
                                toastr.success(res.message);
                            } else {
                                toastr.error(res.message);
                            }
                        },
                        error: function() {
                            $.unblockUI(); // Remove o overlay em caso de erro
                            toastr.error('Ocorreu um erro ao processar a solicitação.');
                        }
                    });
                }
            },
            cancel: {
                label: "<div class='d-flex align-items-center'><i class='bx bx-x mr-2'></i> Cancelar</div>",
                className: 'btn btn-sm btn-danger',
                callback: function() {
                    // Fechar o modal
                    bootbox.hideAll();
                }
            }
        }
    }).find(".modal-dialog").addClass("modal-dialog-centered")
      .find('.modal-header').css({
        'background-color': '#2A2A2A'
    }).find('.modal-title').css({
        'color': '#fff'
    }).find('.modal-header .close').css({
        'color': '#fff'
    });
});
