$(document).on("click", ".excluirApp", function(e) {
    e.preventDefault();

    var appId = $(this).data("id"); // Assume que o ID do aplicativo está armazenado no atributo data-id do botão

    bootbox.dialog({
        title: "Confirmação de exclusão",
        message: "Você tem certeza de que deseja excluir este aplicativo? Esta ação não pode ser desfeita.",
        buttons: {
            noclose: {
                label: "<div class='d-flex align-items-center'><i class='bx bx-check mr-2' ></i> Confirmar </div>",
                className: 'btn btn-sm btn-primary',
                callback: function() {
                    // Mostrar o overlay
                    $.blockUI({ message: '<h1>Processando...</h1>', css: { border: 'none', padding: '15px', backgroundColor: '#fff', 'border-radius': '10px', opacity: .8, color: '#000' } });
                    
                    $.ajax({
                        url: "./api/aplicativos/excluir", // URL para o endpoint de exclusão
                        type: "POST",
                        data: { id: appId },
                        success: function(res) {
                            $.unblockUI(); // Remove o overlay em caso de erro
                            if (res.status) {
                                toastr.success(res.message);
                                // Opcional: Atualizar a lista de aplicativos ou remover o item da interface
                                $(`#app-${appId}`).remove(); // Assume que os itens têm IDs no formato app-ID
                            } else {
                                toastr.error(res.message);
                            }
                        },
                        error: function() {
                            $.unblockUI(); // Remove o overlay em caso de erro
                            toastr.error('Ocorreu um erro ao processar a solicitação.');
                        }
                    });
                }
            },
            noclose2: {
                label: "<div class='d-flex align-items-center'><i class='bx bx-x mr-2' ></i> Cancelar </div>",
                className: 'btn btn-sm btn-danger',
                callback: function() {
                    $(this).modal('hide');
                    return false;
                }
            }
        }
    }).find(".modal-dialog").addClass("modal-dialog-centered").find('.modal-header').css({
        'background-color': '#2A2A2A'
    }).find('.modal-title').css({
        'color': '#fff'
    }).find('.modal-header .close').css({
        'color': '#fff'
    });
});
