<!DOCTYPE html>
<html lang="pt-br">

<head>
    <?php include "./includes/head.php"; ?>
    <style>
        body {
            transition: background 0.5s;
        }
    </style>
</head>
<body>

    <!--*******************
        Preloader start
    ********************-->
    <div id="preloader">
        <div class="sk-three-bounce">
            <div class="sk-child sk-bounce1"></div>
            <div class="sk-child sk-bounce2"></div>
            <div class="sk-child sk-bounce3"></div>
        </div>
    </div>

    <div id="main-wrapper">

        <div class="nav-header">
            <?php include "./includes/nav_header.php"; ?>
        </div>

        <div class="header">
            <?php include "./includes/header.php"; ?>
        </div>

        <div class="deznav">
            <?php include "./includes/menu.php"; ?>
        </div>

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <div class="form-head page-titles d-flex mb-md-4">
                    <div class="mr-auto">
                        <h2 class="text-black font-w600">Meus aplicativos</h2>
                    </div>
                    <div class="d-sm-flex d-block mb-0 align-items-end">
                        <div class="dropdown d-inline-block mb-2">
                            <div class="btn btn-primary adicionarApp d-flex justify-content-center align-items-center" role="button">
                                <i class='bx bx-plus mr-2'></i> Novo aplicativo
                            </div>
                        </div>
                    </div>
                </div>
                <button id="colorToggle" class="btn btn-secondary mb-3">Mudar Cor de Fundo</button> <!-- Botão para mudar a cor -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="tab-content">
                            <div id="navpills-1" class="tab-pane active show fade">

                                <?php 
                                include_once "../autoload.php";
                                include_once "./configuracoes/functions.php";
                                $aplicativos = new Aplicativos;
                                $getApps = $aplicativos->getAllApplications();

                                foreach ($getApps["data"] as $key => $app) :
                                    $key++;
                                ?>

                                <div class="card review-table mb-2 app-<?php echo $app["id"]; ?>">
                                    <div class="media">
                                        <img class="mr-3 img-fluid" width="110" src="./assets/images/android.webp" alt="Aplicativo <?php echo $key; ?>">
                                        <div class="media-body">
                                            <h3 class="fs-20 text-black font-w600 mb-3"><a href="javascript:void;" class="text-black"><?php echo $app["name"]; ?></a></h3>
                                            <p><?php echo $app["description"]; ?></p>
                                            <span class="fs-15"><strong>Tamanho do arquivo: <br/> </strong> <?php echo $app["size"]; ?> MB</span>
                                        </div>
                                        <div class="media-footer d-flex align-self-center">
                                            <div class="disease mr-5">
                                                <p class="mb-1 fs-14">Status</p>
                                                <h4 class="<?php echo $app["status"] == "Active" ? "text-success" : "text-danger"; ?>"><?php echo $app["status"] == "Active" ? "PUBLICADO" : "DESATIVADO"; ?></h4>
                                            </div>
                                            <div class="disease mr-5">
                                                <p class="mb-1 fs-14">Categoria</p>
                                                <h4 class="text-primary"><?php echo $app["p2p"] === "Yes" ? "P2P" : "IPTV"; ?></h4>
                                            </div>
                                            <div class="disease mr-5">
                                                <p class="mb-1 fs-14">Ordem</p>
                                                <h4 class="text-primary"><?php echo $app["orderBy"]; ?></h4>
                                            </div>
                                            <div class="edit ml-auto">
                                                <div class="dropdown custom-dropdown">
                                                    <div class="btn sharp btn-primary tp-btn" data-toggle="dropdown">
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18px" height="18px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><circle fill="#000000" cx="12" cy="5" r="2"/><circle fill="#000000" cx="12" cy="12" r="2"/><circle fill="#000000" cx="12" cy="19" r="2"/></g></svg>
                                                    </div>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <a class="dropdown-item d-flex align-items-center editarApp" data-id="<?php echo $app['id']; ?>" href="#"><i class='bx bx-edit-alt mr-2'></i>Editar</a>
                                                        <a class="dropdown-item d-flex align-items-center excluirApp" data-id="<?php echo $app['id']; ?>" href="#"><i class='bx bx-trash mr-2'></i>Excluir</a>
                                                        <a class="dropdown-item d-flex align-items-center statusApp <?php echo $app['status'] === "Active" ? "text-danger" : "text-success"; ?>" data-id="<?php echo $app['id']; ?>" data-status="<?php echo $app['status']; ?>" href="#"><i class='bx bx-power-off mr-2'></i><?php echo $app['status'] === "Active" ? "Desativar" : "Ativar"; ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="footer">
            <?php include "./includes/footer.php"; ?>
        </div>

    </div>

    <!--**********************************
        Scripts
    ***********************************-->
    <!-- Required vendors -->
    <script src="./assets/vendor/global/global.min.js"></script>
    <script src="./assets/vendor/dropzone/dist/min/dropzone.min.js"></script>
    <script src="./assets/js/custom.min.js"></script>
    <script src="./assets/js/deznav-init.js"></script>
    
    <!-- blockUI -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.blockUI/2.70/jquery.blockUI.min.js"></script>

    <!-- Toastr -->
    <script src="./assets/vendor/toastr/js/toastr.min.js"></script>

    <!-- Bootbox -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/4.4.0/bootbox.min.js"></script>


    <script src="./javascript/aplicativos/adicionar.js"></script>
    <script src="./javascript/aplicativos/editar.js"></script>
    <script src="./javascript/aplicativos/excluir.js"></script>
    <script src="./javascript/aplicativos/status.js"></script>
    
    <script src="./javascript/usuarios/alterarSenha.js"></script>

    <script>
        let isGradient = false;

        document.getElementById('colorToggle').addEventListener('click', function() {
            if (isGradient) {
                document.body.style.background = 'lightblue'; // Cor suave
            } else {
                document.body.style.background = 'linear-gradient(to right, #ff7e5f, #feb47b)'; // Degradê
            }
            isGradient = !isGradient;
        });
    </script>

</body>
</html>
