<?php
setlocale( LC_ALL, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese' );
date_default_timezone_set('America/Sao_Paulo');

if (file_exists(__DIR__ . "/config.php")) {
	include_once __DIR__ . "/config.php";
}

/**
 * Classe Conexão PDO
 */
class DB
{
	private $connection = NULL;
	private static $_instance = NULL;
	
	public static function getInstance()
	{
		if (!self::$_instance) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
	
	
	public function getConnection($db_host, $db_port, $db_name, $db_user, $db_pass)
	{
		$con_name = $db_host . "_" . $db_name;
		try {
			if (!isset($this->connection[$con_name])) {
				$this->connection[$con_name] = new PDO("mysql:host=" . $db_host . ";port=" . $db_port . ";dbname=" . $db_name . ";charset=utf8", $db_user, $db_pass, array(PDO::ATTR_PERSISTENT => true, PDO::ATTR_TIMEOUT => 5));
				$this->connection[$con_name]->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			}
		} catch (PDOException $e) {
			return NULL;
		} catch (Exception $d) {
			return NULL;
		}
		return $this->connection[$con_name];
	}
}



/**
 * Conecta com o MySQL usando PDO
 */
function conexaoPDOlocal()
{
	return DB::getInstance()->getConnection(DB_HOST, DB_PORT, DB_NAME, DB_USER, DB_PASS);
}



/**
 * Formata uma data timestamp para PT-BR
 * recebe: @param inteiro $data 
 */
function formataData($data){
	$mess = date("m", $data);
	$diaa = date("d", $data);
	$anoo = date("Y", $data);
	$hora = date("H", $data);
	$minu = date("i", $data);
	$segu = date("s", $data);
	$month   = array(
		"01" => "Jan", "02" => "Fev", "03" => "Mar", "04" => "Abr", "05" => "Mai", "06" => "Jun", "07" => "Jul", "08" => "Ago", "09" => "Set", "10" => "Out", "11" => "Nov", "12" => "Dez"
	);
	$mes = $month[$mess];
	return $diaa . ' '. $mes . ' '. $anoo . ' - ' . $hora . ':' . $minu.':'.$segu;
}