<?php


/**
 * Desenvolvido por script php brasil
 * https://scriptphpbrasil.com.br
 */

class Ofuscador {

    public function criptografar($json) {
        $json = json_decode($json, true);
        $json = stripslashes(json_encode($json));

        // Lista de substituições aleatórias e únicas
        $substituicao = array(
            '%' => 'XjT',
            '+' => 'vNk',
            'a' => 'QgB',
            'b' => 'HzL',
            'c' => 'RfM',
            'd' => 'wEj',
            'e' => 'LpC',
            'f' => 'ZxQ',
            'g' => 'AdY',
            'h' => 'UoR',
            'i' => 'KsW',
            'j' => 'NpF',
            'k' => 'VeH',
            'l' => 'BrI',
            'm' => 'CtJ',
            'n' => 'FgS',
            'o' => 'HwL',
            'p' => 'OmX',
            'q' => 'YiV',
            'r' => 'UjP',
            's' => 'XeT',
            't' => 'VpG',
            'u' => 'RqB',
            'v' => 'LaF',
            'w' => 'KtN',
            'x' => 'OiC',
            'y' => 'ErH',
            'z' => 'WjL',
            '"' => 'GdA',
            '\'' => 'FsE',
            '{' => 'CtV',
            '}' => 'BrQ',
            '[' => 'LmZ',
            ']' => 'NpK',
            ':' => 'XcH',
            ',' => 'PdR',
            '=' => 'YfW',
            '0' => 'QmN',
            '1' => 'KtL',
            '2' => 'RxJ',
            '3' => 'SzD',
            '4' => 'UmF',
            '5' => 'VlG',
            '6' => 'BgH',
            '7' => 'JpK',
            '8' => 'NzR',
            '9' => 'AoS',
            ' ' => 'PqT',
            '!' => 'EuW',
            '?' => 'DrX',
            '.' => 'McY',
            '/' => 'FgZ',
            '\\' => 'HpA',
            ';' => 'QvB',
            '&' => 'RjK',
            '@' => 'WmL',
            '-' => 'XsP',
            '_' => 'ZfT',
            '#' => 'LjN',
            'A' => 'tQk',
            'B' => 'VmL',
            'C' => 'jRz',
            'D' => 'hGf',
            'E' => 'YkW',
            'F' => 'NpV',
            'G' => 'ZxB',
            'H' => 'QjC',
            'I' => 'FzK',
            'J' => 'WnM',
            'K' => 'HrL',
            'L' => 'CoP',
            'M' => 'XbV',
            'N' => 'SyT',
            'O' => 'gHf',
            'P' => 'LpR',
            'Q' => 'JzK',
            'R' => 'mFZ',
            'S' => 'nCj',
            'T' => 'XkP',
            'U' => 'YwQ',
            'V' => 'rLJ',
            'W' => 'tXp',
            'X' => 'ZdK',
            'Y' => 'uGh',
            'Z' => 'oFq',
            // Acentos e caracteres especiais
            'á' => 'LjX',
            'à' => 'RzY',
            'â' => 'TqG',
            'ã' => 'KpD',
            'é' => 'MqL',
            'è' => 'XwV',
            'ê' => 'CnF',
            'í' => 'BrS',
            'ì' => 'DkJ',
            'ó' => 'LrH',
            'ò' => 'FpG',
            'ô' => 'TnX',
            'õ' => 'ZjB',
            'ú' => 'KmL',
            'ù' => 'RjQ',
            'ü' => 'FsP',
            'ç' => 'VgN',
            'ñ' => 'MwL',
            'ä' => 'HxY',
            'ë' => 'LzR',
            'ï' => 'PbT',
            'ö' => 'TjK'
        );

        // Aplicar a substituição na string
        $api = strtr($json, $substituicao);
        return $api;
    }


    /**
 * Desenvolvido por scrip php brasil
 * https://scriptphpbrasil.com.br
 */
    public function descriptografar($json) {
        $substituicao = array(
            'XjT' => '%',
            'vNk' => '+',
            'QgB' => 'a',
            'HzL' => 'b',
            'RfM' => 'c',
            'wEj' => 'd',
            'LpC' => 'e',
            'ZxQ' => 'f',
            'AdY' => 'g',
            'UoR' => 'h',
            'KsW' => 'i',
            'NpF' => 'j',
            'VeH' => 'k',
            'BrI' => 'l',
            'CtJ' => 'm',
            'FgS' => 'n',
            'HwL' => 'o',
            'OmX' => 'p',
            'YiV' => 'q',
            'UjP' => 'r',
            'XeT' => 's',
            'VpG' => 't',
            'RqB' => 'u',
            'LaF' => 'v',
            'KtN' => 'w',
            'OiC' => 'x',
            'ErH' => 'y',
            'WjL' => 'z',
            'GdA' => '"',
            'FsE' => '\'',
            'CtV' => '{',
            'BrQ' => '}',
            'LmZ' => '[',
            'NpK' => ']',
            'XcH' => ':',
            'PdR' => ',',
            'YfW' => '=',
            'QmN' => '0',
            'KtL' => '1',
            'RxJ' => '2',
            'SzD' => '3',
            'UmF' => '4',
            'VlG' => '5',
            'BgH' => '6',
            'JpK' => '7',
            'NzR' => '8',
            'AoS' => '9',
            'PqT' => ' ',
            'EuW' => '!',
            'DrX' => '?',
            'McY' => '.',
            'FgZ' => '/',
            'HpA' => '\\',
            'QvB' => ';',
            'RjK' => '&',
            'WmL' => '@',
            'XsP' => '-',
            'ZfT' => '_',
            'LjN' => '#',
            'tQk' => 'A',
            'VmL' => 'B',
            'jRz' => 'C',
            'hGf' => 'D',
            'YkW' => 'E',
            'NpV' => 'F',
            'ZxB' => 'G',
            'QjC' => 'H',
            'FzK' => 'I',
            'WnM' => 'J',
            'HrL' => 'K',
            'CoP' => 'L',
            'XbV' => 'M',
            'SyT' => 'N',
            'gHf' => 'O',
            'LpR' => 'P',
            'JzK' => 'Q',
            'mFZ' => 'R',
            'nCj' => 'S',
            'XkP' => 'T',
            'YwQ' => 'U',
            'rLJ' => 'V',
            'tXp' => 'W',
            'ZdK' => 'X',
            'uGh' => 'Y',
            'oFq' => 'Z',
            'LjX' => 'á',
            'RzY' => 'à',
            'TqG' => 'â',
            'KpD' => 'ã',
            'MqL' => 'é',
            'XwV' => 'è',
            'CnF' => 'ê',
            'BrS' => 'í',
            'DkJ' => 'ì',
            'LrH' => 'ó',
            'FpG' => 'ò',
            'TnX' => 'ô',
            'ZjB' => 'õ',
            'KmL' => 'ú',
            'RjQ' => 'ù',
            'FsP' => 'ü',
            'VgN' => 'ç',
            'MwL' => 'ñ',
            'HxY' => 'ä',
            'LzR' => 'ë',
            'PbT' => 'ï',
            'TjK' => 'ö'
        );

        // Aplicar a substituição na string criptografada
        $textoDescriptografado = strtr($json, $substituicao);

        // Corrigir caracteres Unicode escapados
        return stripslashes($textoDescriptografado);
    }
}