<?php
include '../../configuracoes/functions.php';
include '../../../autoload.php';


/**
 * Desenvolvido por script php brasil
 * https://scriptphpbrasil.com.br
 */

// Define o cabeçalho para JSON
header('Content-Type: application/json');

// Verifica se os dados foram enviados via POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtém os dados do POST
    $id = $_POST['id'] ?? '';
    $name = $_POST['nome'] ?? '';
    $p2p = $_POST['tipo'] ?? '';
    $orderBy = $_POST['ordem'] ?? '';
    $rating = $_POST['estrelas'] ?? '';
    $downloader = $_POST['codigoAFTV'] ?? '';
    $ntdown = $_POST['codigoNTDown'] ?? '';
    $description = $_POST['descricao'] ?? '';
    $developer = $_POST['desenvolvedor'] ?? '';  // Novo campo para o desenvolvedor
    $images = json_decode($_POST['imagensDoAplicativo'], true) ?? [];

    // O arquivo enviado
    $file = $_FILES['files'] ?? null;

    // Validação e sanitização dos dados
    $errors = [];

    // Campos obrigatórios
    if (empty($id)) {
        $errors[] = 'ID do aplicativo é obrigatório.';
    }
    if (empty($name)) {
        $errors[] = 'Nome do aplicativo é obrigatório.';
    }
    if (empty($orderBy) || !is_numeric($orderBy)) {
        $errors[] = 'Ordem de exibição é obrigatória e deve ser um número.';
    }
    if (empty($rating) || !is_numeric($rating)) {
        $errors[] = 'Avaliação é obrigatória e deve ser um número FLOAT.';
    }
    if (empty($p2p)) {
        $errors[] = 'Tipo do aplicativo é obrigatório.';
    }
    if (empty($developer)) {
        $errors[] = 'Desenvolvedor é obrigatório.';
    }

    // Validação do arquivo
    $fileLink = null;
    if ($file && $file['error'][0] === UPLOAD_ERR_OK) {
        // Define o caminho do diretório de uploads
        $uploadDir = '../../../download/';
        
        // Verifica se o diretório de uploads existe, caso contrário, tenta criá-lo
        if (!is_dir($uploadDir)) {
            if (!mkdir($uploadDir, 0777, true)) {
                $errors[] = 'Erro ao criar o diretório de uploads.';
            }
        }

        // Obtém a extensão do arquivo
        $fileExtension = pathinfo($file['name'][0], PATHINFO_EXTENSION);
        
        // Gera um nome de arquivo único usando timestamp
        $uniqueFileName = "/".time().".".$fileExtension;
        
        // Define o caminho do arquivo
        $filePath = $uploadDir . $uniqueFileName;
        
        // Move o arquivo para o diretório de upload
        if (!move_uploaded_file($file['tmp_name'][0], $filePath)) {
            $errors[] = 'Erro ao fazer upload do arquivo.';
        } else {
            $fileLink = $uniqueFileName; // Salva o caminho do arquivo no banco de dados
            $size = round($file['size'][0] / (1024 * 1024), 2); // Tamanho do arquivo em MB
        }
    }

    // Sanitização dos dados
    $name = htmlspecialchars(strip_tags($name));
    $p2p = htmlspecialchars(strip_tags($p2p));
    $orderBy = intval($orderBy);
    $rating = htmlspecialchars(strip_tags($rating));
    $size = isset($size) ? floatval($size) : null; // Atualiza $size com o valor do tamanho do arquivo em MB como float
    $downloader = htmlspecialchars(strip_tags($downloader));
    $ntdown = htmlspecialchars(strip_tags($ntdown));
    $description = htmlspecialchars(strip_tags($description));
    $developer = htmlspecialchars(strip_tags($developer));
    $images = array_map('htmlspecialchars', $images);

    // Se houver erros, retorna uma resposta de erro
    if (!empty($errors)) {
        echo json_encode(['status' => false, 'message' => implode(' ', $errors)]);
        exit;
    }

    // Cria uma instância da classe Aplicativos
    $aplicativo = new Aplicativos();

    // Atualiza o aplicativo no banco de dados
    try {
        $result = $aplicativo->updateApplication(
            $id,
            $name,
            $fileLink, // Link do arquivo, se houver
            $p2p,
            $orderBy,
            $rating,
            $size,
            $downloader,
            $ntdown,
            $description,
            $developer,
            $images
        );
        echo json_encode($result); exit;
    } catch (Exception $e) {
        echo json_encode(['status' => false, 'message' => 'Erro ao atualizar o aplicativo: ' . $e->getMessage()]); exit;
    }
}

echo json_encode(['status' => false, 'message' => 'Método de requisição inválido.']);